/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import org.joml.Vector3f;

public abstract class SyncedAccessoryModel
extends EntityModel<Dog> {
    public final ModelPart root;
    private Vector3f pivot = DogModel.DEFAULT_ROOT_PIVOT;
    public Optional<ModelPart> head = Optional.empty();
    public Optional<ModelPart> realHead = Optional.empty();
    public Optional<ModelPart> body = Optional.empty();
    public Optional<ModelPart> mane = Optional.empty();
    public Optional<ModelPart> legBackRight = Optional.empty();
    public Optional<ModelPart> legBackLeft = Optional.empty();
    public Optional<ModelPart> legFrontRight = Optional.empty();
    public Optional<ModelPart> legFrontLeft = Optional.empty();
    public Optional<ModelPart> tail = Optional.empty();
    public Optional<ModelPart> realTail = Optional.empty();

    public SyncedAccessoryModel(ModelPart root) {
        this.root = root;
        this.populatePart(root);
    }

    protected abstract void populatePart(ModelPart var1);

    public void sync(DogModel dogModel) {
        this.syncPart(this.root, dogModel.root);
        this.syncPart(this.head, dogModel.head);
        this.syncPart(this.realHead, dogModel.realHead);
        this.syncPart(this.body, dogModel.body);
        this.syncPart(this.mane, dogModel.mane);
        this.syncPart(this.legBackRight, dogModel.legBackRight);
        this.syncPart(this.legBackLeft, dogModel.legBackLeft);
        this.syncPart(this.legFrontRight, dogModel.legFrontRight);
        this.syncPart(this.legFrontLeft, dogModel.legFrontLeft);
        this.syncPart(this.tail, dogModel.tail);
        this.syncPart(this.realTail, dogModel.realTail);
        this.pivot = DogModel.DEFAULT_ROOT_PIVOT;
        Vector3f custom_pivot = dogModel.getCustomRootPivotPoint();
        if (custom_pivot != null) {
            this.pivot = custom_pivot;
        }
    }

    private void syncPart(Optional<ModelPart> part, ModelPart dogPart) {
        part.ifPresent(p -> this.syncPart((ModelPart)p, dogPart));
    }

    private void syncPart(ModelPart part, ModelPart dogPart) {
        part.m_104315_(dogPart);
    }

    public void m_7695_(PoseStack stack, VertexConsumer p_103014_, int p_103015_, int p_103016_, float p_103017_, float p_103018_, float p_103019_, float p_103020_) {
        stack.m_85836_();
        stack.m_85837_((double)(this.root.f_104200_ / 16.0f), (double)(this.root.f_104201_ / 16.0f), (double)(this.root.f_104202_ / 16.0f));
        stack.m_85837_((double)(this.pivot.x / 16.0f), (double)(this.pivot.y / 16.0f), (double)(this.pivot.z / 16.0f));
        if (this.root.f_104205_ != 0.0f) {
            stack.m_252781_(Axis.f_252403_.m_252961_(this.root.f_104205_));
        }
        if (this.root.f_104204_ != 0.0f) {
            stack.m_252781_(Axis.f_252436_.m_252961_(this.root.f_104204_));
        }
        if (this.root.f_104203_ != 0.0f) {
            stack.m_252781_(Axis.f_252529_.m_252961_(this.root.f_104203_));
        }
        float xRot0 = this.root.f_104203_;
        float yRot0 = this.root.f_104204_;
        float zRot0 = this.root.f_104205_;
        float x0 = this.root.f_104200_;
        float y0 = this.root.f_104201_;
        float z0 = this.root.f_104202_;
        this.root.f_104203_ = 0.0f;
        this.root.f_104204_ = 0.0f;
        this.root.f_104205_ = 0.0f;
        this.root.f_104200_ = 0.0f;
        this.root.f_104201_ = 0.0f;
        this.root.f_104202_ = 0.0f;
        stack.m_85836_();
        stack.m_85837_((double)(-this.pivot.x / 16.0f), (double)(-this.pivot.y / 16.0f), (double)(-this.pivot.z / 16.0f));
        if (this.f_102610_) {
            boolean headSync = this.head.isPresent();
            boolean headVisible0 = false;
            if (headSync) {
                headVisible0 = this.head.get().f_104207_;
                this.head.get().f_104207_ = false;
            }
            stack.m_85836_();
            this.root.m_104306_(stack, p_103014_, p_103015_, p_103016_, p_103017_, p_103018_, p_103019_, p_103020_);
            stack.m_85849_();
            if (headSync) {
                this.head.get().f_104207_ = headVisible0;
                stack.m_85836_();
                stack.m_85841_(2.0f, 2.0f, 2.0f);
                stack.m_85837_(0.0, -0.5, 0.15);
                this.head.get().m_104306_(stack, p_103014_, p_103015_, p_103016_, p_103017_, p_103018_, p_103019_, p_103020_);
                stack.m_85849_();
            }
        } else {
            this.root.m_104306_(stack, p_103014_, p_103015_, p_103016_, p_103017_, p_103018_, p_103019_, p_103020_);
        }
        stack.m_85849_();
        stack.m_85849_();
        this.root.f_104203_ = xRot0;
        this.root.f_104204_ = yRot0;
        this.root.f_104205_ = zRot0;
        this.root.f_104200_ = x0;
        this.root.f_104201_ = y0;
        this.root.f_104202_ = z0;
    }

    public void prepareMobModel(Dog dogIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
    }

    public void setupAnim(Dog entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }
}

